import React, { useState, useEffect } from "react";
import { useNavigate,  Link, useHistory } from 'react-router-dom';
import Ecomheader from "../../src/header/headershop";
import Ecomfooter from "../footer/footershop";
const LoginPage = () =>{
    const [isPopupVisible, setIsPopupVisible] = useState(false);
  const [email, setEmail] = useState('');
  const [password, setPassword] = useState('');
  const navigate = useNavigate();

  
  const handleLogin = async () => {
    try {
      const response = await fetch('https://api.visakacart.com/api/v1/login/authenticateclient', {
        method: 'PUT',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ 'mobile':email, password }),
      });
  
      if (response.ok) {
        const data = await response.json();
        localStorage.setItem('token', data.token);
  // After successful login, close the login popup
  setIsPopupVisible(false);
navigate('/Cart')
      } else {
        console.error('Client Login failed');
      }
    } catch (error) {
      console.error('Error logging in:', error);
    }
  };
    return(
<div>
<Ecomheader />
<div class="card accordion container">
<div class="alert-body collapsed" id="alert-body1">
<p>If you have shopped with us before, please enter your details below.
If you are a new customer, please proceed to the Billing section.</p>
<div class="row cols-md-2">
<form class="mb-4 mb-md-0">
<label for="username">Username Or Email *</label>
<input type="text" class="input-text form-control mb-0" name="username" id="username" autocomplete="username" placeholder="Your Phone Number *" // Update the placeholder text
        value={email}
        onChange={(e) => setEmail(e.target.value)}/>

<label for="password">Password *</label>
<input class="input-text form-control mb-0" type="password" name="password" id="password" autocomplete="current-password"  placeholder="Password *"
                  value={password}
                  onChange={(e) => setPassword(e.target.value)}/>
</form>
</div>
<div class="checkbox d-flex align-items-center justify-content-between">
{/* <div class="form-checkbox pt-0 mb-0">
<input type="checkbox" class="custom-checkbox" id="signin-remember" name="signin-remember" />
<label class="form-control-label" for="signin-remember">Remember
Me</label>
</div> */}
{/* <a href="#" class="lost-link">Lost your password?</a> */}
</div>
<div class="link-group">
<a href="#" class="btn btn-dark btn-rounded mb-4" onClick={handleLogin}>Login</a>
{/* <span class="d-inline-block text-body font-weight-semi-bold">or Login With</span> */}
</div>
</div>
</div>
<Ecomfooter />
</div>
    );
}
export default LoginPage;